/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.menu;

import emulator.GUI.io.Via6522panel;
import emulator.hardware.io.Via6522;
import emulator.hardware.io.porthistory.PortStateHistory;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.shell.GUI.graph.BitGraph;
import emulator.shell.GUI.menu.GraphWindow;
import emulator.shell.GUI.windows.ManagedWindow;
import emulator.shell.GUI.windows.WindowManager;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JSplitPane;

public class WindowVia
extends GraphWindow
implements ActionListener {
    private WindowManager windowManager;
    private int windowId;
    Via6522 via;
    private ManagedWindow window;
    private String title;
    private Via6522panel panelVia;
    PortStateHistory portStateHistory;

    public WindowVia(WindowManager window_manager, int window_id, String title, Via6522 via, Cpu6502 cpu, PortStateHistory portStateHistory) {
        this.windowManager = window_manager;
        this.windowId = window_id;
        this.title = title;
        this.via = via;
        this.cpu = cpu;
        this.portStateHistory = portStateHistory;
        via.getId();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.windowManager.isWindowActive(this.windowId)) {
            this.closeWindow();
        } else {
            this.openWindow();
        }
    }

    private void openWindow() {
        this.window = this.windowManager.createWindow(this.windowId, this.title);
        this.panelVia = new Via6522panel(this.via, this.title);
        if (this.portStateHistory != null) {
            JSplitPane splitPane = new JSplitPane(1, this.panelVia, this.createGraphFrame());
            splitPane.setOneTouchExpandable(true);
            splitPane.setDividerLocation(this.panelVia.getPreferredSize().width);
            this.window.getContentPane().add(splitPane);
        } else {
            this.window.getContentPane().add(this.panelVia);
        }
        this.window.restorePosition();
        this.window.setVisible(true);
        this.panelVia.updateFromVia();
        this.cpu.addRunningStateObserver(this.cpuObserver);
    }

    private void closeWindow() {
        this.cpu.deleteRunningStateObserver(this.cpuObserver);
        this.panelVia = null;
        this.windowManager.closeWindow(this.windowId);
    }

    @Override
    protected BitGraph createGraph() {
        BitGraph bitGraph = new BitGraph(36);
        int i = 0;
        while (i < 8) {
            bitGraph.getGraphLine(2 * i).setLabel("PA" + i + "i").setStateHistory(this.portStateHistory.getPortAin(i)).setPositionIndex(i).setColor(Color.GRAY);
            bitGraph.getGraphLine(2 * i + 1).setLabel("PA" + i + "o").setStateHistory(this.portStateHistory.getPortAout(i)).setPositionIndex(i);
            bitGraph.getGraphLine(2 * i + 18).setLabel("PB" + i + "i").setStateHistory(this.portStateHistory.getPortBin(i)).setPositionIndex(i + 10).setColor(Color.GRAY);
            bitGraph.getGraphLine(2 * i + 19).setLabel("PB" + i + "o").setStateHistory(this.portStateHistory.getPortBout(i)).setPositionIndex(i + 10);
            ++i;
        }
        i = 0;
        while (i < 2) {
            bitGraph.getGraphLine(16 + i).setLabel("CA" + (i + 1)).setStateHistory(this.portStateHistory.getPortActrl(i)).setPositionIndex(8 + i);
            bitGraph.getGraphLine(34 + i).setLabel("CB" + (i + 1)).setStateHistory(this.portStateHistory.getPortBctrl(i)).setPositionIndex(18 + i);
            ++i;
        }
        return bitGraph;
    }

    @Override
    protected void onCpuStoppped() {
        this.panelVia.updateFromVia();
    }

    @Override
    protected long getMaxTicks() {
        return this.via.getTicks();
    }
}

